% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes.R
\name{bayes}
\alias{bayes}
\title{Cpp implementation of the Bayesian projection algorithm to detect single multivariate changepoints.}
\usage{
bayes(x, threshold, nTimePoints = NULL, K = 1/sqrt(2), rescale.var = TRUE)
}
\arguments{
\item{x}{A \eqn{p \times n} matrix representing \eqn{p} data series having \eqn{n} observations each.}

\item{threshold}{The testing threshold to detect the single changepoint. If missing, parameter will be calibrated automatically.}

\item{nTimePoints}{The number of equidistant timepoints at which the projection direction is calculated. If no value (NULL) is given, timepoints are chosen automatically.}

\item{K}{The regularisation parameter for the Bayesian projection direction. Default is \eqn{1/\sqrt(2)}.}

\item{rescale.var}{A boolean flag to indicate if the variance should be rescaled before detecting a changepoint. Default is TRUE.}
}
\description{
Detects one multivariate changepoint in a dataset using the fast projection direction algorithm of Hahn et al. (2019).
Solely required is the dataset as first parameter.
The testing threshold ("threshold"), the number of timepoints to calculate a projection ("nTimePoints") and the regularisation parameter ("K") are chosen automatically.
}
\examples{
library(BayesProject)
data(testdata)
res <- bayes(testdata,nTimePoints=100)
print(res$cpt)

}
\references{
Hahn, G., Fearnhead, P., Eckley, I.A. (2020). Fast computation of a projection direction for multivariate changepoint detection. Stat Comput.
}
