% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes.R
\name{wildBinSeg}
\alias{wildBinSeg}
\title{Wild Binary Segmentation Wrapper for the functions "bayes" and "summaxcusum".}
\usage{
wildBinSeg(x, cusumFct, threshold, m = 100, minwindow = 10, rescale.var = TRUE)
}
\arguments{
\item{x}{A \eqn{p \times n} matrix representing \eqn{p} data series having \eqn{n} observations each.}

\item{cusumFct}{A calibrated function which returns a cusum vector for a dataset supplied as its single input parameter. Note that rescaling of the variance should be deactivated inside "cusumFct". When using the function "bayes" as in the example below, it is advised to set the threshold to e.g. zero in order to deactivate the time-consuming (and unnecessary) threshold computation inside "bayes".}

\item{threshold}{The testing threshold to detect the single changepoint. The threshold must be specified.}

\item{m}{The number of random WBS intervals on each recursion level.}

\item{minwindow}{The minimal window size up to which the dataset is further divided recursively to find more changepoints.}

\item{rescale.var}{A boolean flag to indicate if the variance should be rescaled before detecting a changepoint. Default is TRUE.}
}
\description{
Detects multivariate changepoints in a dataset using the Wild Binary Segmentation framework of Fryzlewicz (2014).
The dataset is supplied as the first parameter.
The second parameter is a calibrated function "cusumFct(x)" which takes a multivariate data matrix \eqn{x} and returns a cusum vector for it.
The threshold is supplied with parameter "threshold", parameter "m" specifies the number of random WBS intervals on each recursion level,
and "minwindow" is the minimal window size up to which the dataset is further divided recursively to find more changepoints.
}
\examples{
library(BayesProject)
data(testdata)
bayes_cusum <- function(x) bayes(x,threshold=0,rescale.var=FALSE)$cusum
res <- wildBinSeg(testdata, cusumFct=bayes_cusum, threshold=1)
print(res)

}
\references{
Fryzlewicz, P. (2014). Wild binary segmentation for multiple change-point detection. Ann Statist, 42(6):2243--2281.
}
