% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_MCMC_graph.R
\name{func_MCMC_graph}
\alias{func_MCMC_graph}
\title{Function to learn MRF graph}
\usage{
func_MCMC_graph(sobj, hyperpar, ini, S, method, MRF_2b, cpp = FALSE)
}
\arguments{
\item{sobj}{a list containing observed data from \code{n} subjects;
\code{t}, \code{di}, \code{X}. See details for more information}

\item{hyperpar}{a list containing prior parameter values}

\item{ini}{a list containing prior parameters' ini values}

\item{S}{the number of subgroups}

\item{method}{a method option from
\code{c("Pooled", "CoxBVSSL", "Sub-struct")}}

\item{MRF_2b}{two different b in MRF prior for subgraphs G_ss and G_rs}

\item{cpp}{logical, whether to use C++ code for faster computation}
}
\value{
A list object with components "Sig" the updated covariance matrices,
"G.ini" the updated graph, "V.ini" the updated variances for precision
matrices in all subgroups, "C.ini" the updated precision matrices omega for
each subgroup
}
\description{
This an internal function for MCMC sampling
}
