% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{posterior_multiplicative}
\alias{posterior_multiplicative}
\title{Multiplicative posterior (Hadamard product + renormalization)}
\usage{
posterior_multiplicative(P, LT)
}
\arguments{
\item{P}{Prior matrix (\eqn{T \times K}); filas no negativas.}

\item{LT}{Likelihood matrix (\eqn{T \times K}); filas no negativas.}
}
\value{
Posterior matrix \eqn{W} (\eqn{T \times K}), filas suman 1.
}
\description{
Computes \eqn{W \propto P \odot LT}{W ~ P * LT} (producto elemento a elemento) y
renormaliza cada fila a la simplex. Útil cuando prior y likelihood deben
reforzarse mutuamente.
}
\examples{
T <- 4; K <- 4
P  <- matrix(runif(T*K), T); P  <- P / rowSums(P)
LT <- matrix(runif(T*K), T); LT <- LT / rowSums(LT)
W <- posterior_multiplicative(P, LT)

}
\seealso{
\code{\link{posterior_weighted}}, \code{\link{posterior_dirichlet}},
  \code{\link{posterior_adaptive}}
}
