/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.continuous.OrderedLatentLiabilityLikelihood;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.evomodelxml.treelikelihood.TreeTraitParserUtilities;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Arrays;
import org.ejml.data.DenseMatrix64F;

public class ExtendedLatentLiabilityGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator,
Reportable {
    private final ContinuousExtensionDelegate extensionDelegate;
    private final OrderedLatentLiabilityLikelihood latentLiabilityLikelihood;
    private final ModelExtensionProvider.NormalExtensionProvider dataModel;
    private static final int MAX_REJECT = 1000;
    private static final String EXTENDED_LATENT_GIBBS = "extendedLatentLiabilityGibbsOperator";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
            String string = xMLObject.getAttribute("traitName", TreeTraitParserUtilities.getTipTraitNameFromDataLikelihood((TreeDataLikelihood)treeDataLikelihood));
            TreeTrait treeTrait = treeDataLikelihood.getTreeTrait(string);
            ContinuousTraitPartialsProvider continuousTraitPartialsProvider = continuousDataLikelihoodDelegate.getDataModel();
            ModelExtensionProvider.NormalExtensionProvider normalExtensionProvider = (ModelExtensionProvider.NormalExtensionProvider)continuousTraitPartialsProvider.getProviderForTrait(string);
            Tree tree = treeDataLikelihood.getTree();
            ContinuousExtensionDelegate continuousExtensionDelegate = normalExtensionProvider.getExtensionDelegate(continuousDataLikelihoodDelegate, treeTrait, tree);
            OrderedLatentLiabilityLikelihood orderedLatentLiabilityLikelihood = (OrderedLatentLiabilityLikelihood)xMLObject.getChild(OrderedLatentLiabilityLikelihood.class);
            return new ExtendedLatentLiabilityGibbsOperator(normalExtensionProvider, continuousExtensionDelegate, orderedLatentLiabilityLikelihood);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(TreeDataLikelihood.class), new ElementRule(OrderedLatentLiabilityLikelihood.class), AttributeRule.newStringRule("traitName", true)};
        }

        @Override
        public String getParserDescription() {
            return "Gibbs sampler for the latent variables under the latent liability model when latent traits arise according to Gaussian extension of the process on the tree.";
        }

        @Override
        public Class getReturnType() {
            return ExtendedLatentLiabilityGibbsOperator.class;
        }

        @Override
        public String getParserName() {
            return ExtendedLatentLiabilityGibbsOperator.EXTENDED_LATENT_GIBBS;
        }
    };

    ExtendedLatentLiabilityGibbsOperator(ModelExtensionProvider.NormalExtensionProvider normalExtensionProvider, ContinuousExtensionDelegate continuousExtensionDelegate, OrderedLatentLiabilityLikelihood orderedLatentLiabilityLikelihood) {
        this.extensionDelegate = continuousExtensionDelegate;
        this.latentLiabilityLikelihood = orderedLatentLiabilityLikelihood;
        this.dataModel = normalExtensionProvider;
        if (!normalExtensionProvider.diagonalVariance() && normalExtensionProvider.getDataDimension() > 1) {
            throw new RuntimeException("extendedLatentLiabilityGibbsOperator is only valid for extended models with diagonal variance.");
        }
    }

    @Override
    public String getOperatorName() {
        return EXTENDED_LATENT_GIBBS;
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        int n3 = this.extensionDelegate.getTree().getExternalNodeCount();
        double[] dArray = this.extensionDelegate.getTransformedTraits();
        DenseMatrix64F denseMatrix64F = this.dataModel.getExtensionVariance();
        ArrayList<Integer> arrayList = this.latentLiabilityLikelihood.getConstrainedTraits();
        double[] dArray2 = new double[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            n = arrayList.get(n2);
            dArray2[n2] = Math.sqrt(denseMatrix64F.get(n, n));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = 0;
            int n4 = this.dataModel.getDataDimension() * n2;
            for (int n5 : arrayList) {
                double d = Double.NaN;
                int n6 = n4 + n5;
                double d2 = dArray[n6];
                boolean bl = false;
                for (int i = 0; !bl && i < 1000; ++i) {
                    d = MathUtils.nextGaussian() * dArray2[n] + d2;
                    bl = this.latentLiabilityLikelihood.validTraitForTip(d, n2, n5);
                }
                if (bl) {
                    this.dataModel.getParameter().getParameter(n2).setParameterValueQuietly(n5, d);
                }
                ++n;
            }
        }
        this.dataModel.getParameter().fireParameterChangedEvent();
        return 0.0;
    }

    @Override
    public String getReport() {
        int n;
        int n2;
        CompoundParameter compoundParameter = this.dataModel.getParameter();
        int n3 = compoundParameter.getParameterCount();
        int n4 = compoundParameter.getParameter(0).getDimension();
        int n5 = 20000;
        int n6 = compoundParameter.getDimension();
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n6];
        Arrays.fill(dArray2, Double.POSITIVE_INFINITY);
        Arrays.fill(dArray3, Double.NEGATIVE_INFINITY);
        for (n2 = 0; n2 < n5; ++n2) {
            this.doOperation();
            for (n = 0; n < n6; ++n) {
                double d = compoundParameter.getParameterValue(n);
                int n7 = n;
                dArray[n7] = dArray[n7] + d;
                if (d < dArray2[n]) {
                    dArray2[n] = d;
                }
                if (!(d > dArray3[n])) continue;
                dArray3[n] = d;
            }
        }
        n2 = 0;
        while (n2 < n6) {
            int n8 = n2++;
            dArray[n8] = dArray[n8] / (double)n5;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("extendedLatentLiabilityGibbsOperator report:\n");
        for (n = 0; n < n3; ++n) {
            int n9;
            Parameter parameter = compoundParameter.getParameter(n);
            String string = parameter.getId();
            int n10 = n * n4;
            stringBuilder.append("\t" + string + " mean:\t");
            for (n9 = 0; n9 < n4; ++n9) {
                stringBuilder.append(dArray[n10 + n9]);
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n\t" + string + " minimum:\t");
            for (n9 = 0; n9 < n4; ++n9) {
                stringBuilder.append(dArray2[n10 + n9]);
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n\t" + string + " maximum:\t");
            for (n9 = 0; n9 < n4; ++n9) {
                stringBuilder.append(dArray3[n10 + n9]);
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n\n");
        }
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

