/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.ReciprocalStatistic;
import dr.inference.model.Statistic;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class CorrelationStatistic
extends Statistic.Abstract {
    public static final String CORRELATION_STATISTIC = "correlation";
    public static final String DIMENSION1 = "dimension1";
    public static final String DIMENSION2 = "dimension2";
    private MatrixParameter precision = null;
    private int dim1;
    private int dim2;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class, 1, 1), AttributeRule.newIntegerRule("dimension1"), AttributeRule.newIntegerRule("dimension2")};

        @Override
        public String getParserName() {
            return CorrelationStatistic.CORRELATION_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getChild(MatrixParameter.class);
            int n = xMLObject.getIntegerAttribute(CorrelationStatistic.DIMENSION1);
            int n2 = xMLObject.getIntegerAttribute(CorrelationStatistic.DIMENSION2);
            if (n < 1 || n > matrixParameter.getRowDimension() || n2 < 1 || n2 > matrixParameter.getColumnDimension()) {
                throw new XMLParseException("Invalid dimensions in " + this.getParserName() + " element");
            }
            return new CorrelationStatistic(CorrelationStatistic.CORRELATION_STATISTIC, matrixParameter, n, n2);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a precision that is the element-wise reciprocal of the child precision.";
        }

        @Override
        public Class getReturnType() {
            return ReciprocalStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public CorrelationStatistic(String string, MatrixParameter matrixParameter, int n, int n2) {
        super(string);
        this.precision = matrixParameter;
        this.dim1 = n - 1;
        this.dim2 = n2 - 1;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        double[][] dArray = new SymmetricMatrix(this.precision.getParameterAsMatrix()).inverse().toComponents();
        return dArray[this.dim1][this.dim2] / Math.sqrt(dArray[this.dim1][this.dim1] * dArray[this.dim2][this.dim2]);
    }
}

