/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inferencexml.operators.SelectorOperatorParser;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class SelectorOperator
extends SimpleMCMCOperator {
    private final Parameter selector;
    private final int[] np_m1;
    private final int[] np_m2;

    public SelectorOperator(Parameter parameter) {
        int n;
        this.selector = parameter;
        int n2 = parameter.getSize();
        this.np_m1 = new int[n2 + 1];
        for (n = 0; n < this.np_m1.length; ++n) {
            this.np_m1[n] = SelectorOperator.npos(n2, n);
        }
        this.np_m2 = new int[n2 + 1];
        this.np_m2[0] = 1;
        for (n = 0; n < n2; ++n) {
            this.np_m2[n + 1] = 0;
            for (int i = 1; i < n2 + 1; ++i) {
                int n3 = n + 1;
                this.np_m2[n3] = this.np_m2[n3] + SelectorOperator.npos(i, n);
            }
        }
    }

    @Override
    public String getOperatorName() {
        return SelectorOperatorParser.SELECTOR_OPERATOR + "(" + this.selector.getParameterName() + ")";
    }

    @Override
    public double doOperation() {
        int[] nArray = this.vals();
        List<Integer> list = this.movesFrom_m2(nArray);
        int n = MathUtils.nextInt(list.size() / 2);
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Integer n2 = list.get(2 * n);
        nArray2[n2.intValue()] = list.get(2 * n + 1);
        double d = SelectorOperator.count_sr_m2(nArray, nArray2);
        this.selector.setParameterValue(n2, nArray2[n2]);
        return Math.log(d *= (double)(list.size() * this.np_m2[SelectorOperator.max(nArray) + 1]) / (double)(this.movesFrom_m2(nArray2).size() * this.np_m2[SelectorOperator.max(nArray2) + 1]));
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    private int[] vals() {
        return SelectorOperator.intVals(this.selector);
    }

    static int[] intVals(Variable<Double> variable) {
        int[] nArray = new int[variable.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            double d;
            nArray[i] = (int)(d + ((d = variable.getValue(i).doubleValue()) >= 0.0 ? 0.5 : -0.5));
        }
        return nArray;
    }

    private List<Integer> movesFrom_m2(int[] nArray) {
        int n = SelectorOperator.max(nArray);
        int[] nArray2 = SelectorOperator.counts_used_m2(nArray, n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            int n3 = nArray[i];
            if (n3 < 0) {
                arrayList.add(i);
                arrayList.add(0);
                if (n >= 0) {
                    arrayList.add(i);
                    arrayList.add(n + 1);
                }
                for (n2 = 1; n2 < n + 1; ++n2) {
                    if (nArray2[n2] + 1 > nArray2[n2 - 1]) continue;
                    arrayList.add(i);
                    arrayList.add(n2);
                }
                continue;
            }
            if (n3 < n && (nArray2[n3] == 1 || nArray2[n3] == nArray2[n3 + 1])) continue;
            for (n2 = 0; n2 < n + 1; ++n2) {
                if (n2 == n3 || (n2 <= n3 || nArray2[n3] - 1 < nArray2[n2] + 1 || nArray2[n2 - 1] < nArray2[n2] + 1) && (n2 >= n3 || (n2 <= 0 || nArray2[n2] + 1 > nArray2[n2 - 1]) && n2 != 0)) continue;
                arrayList.add(i);
                arrayList.add(n2);
            }
            if (nArray2[n3] > 1) {
                arrayList.add(i);
                arrayList.add(n + 1);
            }
            arrayList.add(i);
            arrayList.add(-1);
        }
        return arrayList;
    }

    private List<Integer> movesFrom_m1(int[] nArray) {
        int n = SelectorOperator.max(nArray);
        int[] nArray2 = SelectorOperator.counts_m1(nArray, n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < n && (nArray2[n2] == 1 || nArray2[n2] == nArray2[n2 + 1])) continue;
            for (int j = 0; j < n + 1; ++j) {
                if (j == n2 || (j <= n2 || nArray2[n2] - 1 < nArray2[j] + 1 || nArray2[j - 1] < nArray2[j] + 1) && (j >= n2 || (j <= 0 || nArray2[j] + 1 > nArray2[j - 1]) && j != 0)) continue;
                arrayList.add(i);
                arrayList.add(j);
            }
            if (nArray2[n2] <= 1) continue;
            arrayList.add(i);
            arrayList.add(n + 1);
        }
        return arrayList;
    }

    private static int npos(int n, int n2) {
        return SelectorOperator.npos(n, n2, 1);
    }

    private static int npos(int n, int n2, int n3) {
        int n4;
        if (n2 == 0 || n == 0) {
            return 1;
        }
        int n5 = 0;
        for (int i = n3; i < 1 + n / n2 && (n4 = n - i * (n2 + 1)) >= 0; ++i) {
            n5 += SelectorOperator.npos(n4, n2 - 1, 0);
        }
        return n5;
    }

    private static int sum(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private static int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (n >= nArray[i]) continue;
            n = nArray[i];
        }
        return n;
    }

    private static int[] counts_m1(int[] nArray, int n) {
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = nArray;
        int n2 = nArray3.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = n3 = nArray3[i];
            nArray2[n4] = nArray2[n4] + 1;
        }
        return nArray2;
    }

    private static int[] counts_m2(int[] nArray, int n) {
        int[] nArray2 = new int[n + 2];
        for (int n2 : nArray) {
            int n3 = n2 + 1;
            nArray2[n3] = nArray2[n3] + 1;
        }
        return nArray2;
    }

    static int[] counts_m2(int[] nArray) {
        return SelectorOperator.counts_m2(nArray, SelectorOperator.max(nArray));
    }

    private static int[] counts_used_m2(int[] nArray, int n) {
        int[] nArray2 = new int[n + 1];
        for (int n2 : nArray) {
            if (n2 < 0) continue;
            int n3 = n2;
            nArray2[n3] = nArray2[n3] + 1;
        }
        return nArray2;
    }

    static int[] counts_used_m2(int[] nArray) {
        return SelectorOperator.counts_used_m2(nArray, SelectorOperator.max(nArray));
    }

    private static long choose(int n, int n2) {
        double d = 1.0;
        while (n > n2) {
            d *= (double)n;
            d /= (double)(n - n2);
            --n;
        }
        return (long)(d + 0.5);
    }

    private static long[] countl_m1(int[] nArray) {
        int n = SelectorOperator.sum(nArray);
        int n2 = 0;
        long[] lArray = new long[nArray.length];
        while (n > 0) {
            lArray[n2] = SelectorOperator.choose(n, nArray[n2]);
            n -= nArray[n2];
            ++n2;
        }
        return lArray;
    }

    private static double count_sr_m1(int[] nArray, int[] nArray2) {
        int n;
        long[] lArray = SelectorOperator.countl_m1(SelectorOperator.counts_m1(nArray, SelectorOperator.max(nArray)));
        long[] lArray2 = SelectorOperator.countl_m1(SelectorOperator.counts_m1(nArray2, SelectorOperator.max(nArray2)));
        int n2 = Math.min(lArray.length, lArray2.length);
        double d = 1.0;
        for (n = 0; n < n2; ++n) {
            d *= (double)lArray[n];
            d /= (double)lArray2[n];
        }
        for (n = n2; n < lArray.length; ++n) {
            d *= (double)lArray[n];
        }
        for (n = n2; n < lArray2.length; ++n) {
            d /= (double)lArray2[n];
        }
        return d;
    }

    private static long[] countl_m2(int[] nArray) {
        if (nArray.length == 1) {
            return new long[]{1L};
        }
        int n = SelectorOperator.sum(nArray);
        long[] lArray = new long[nArray.length];
        lArray[0] = SelectorOperator.choose(n, nArray[0]);
        n -= nArray[0];
        int n2 = 1;
        while (n > 0) {
            lArray[n2] = SelectorOperator.choose(n, nArray[n2]);
            n -= nArray[n2];
            ++n2;
        }
        return lArray;
    }

    private static double count_sr_m2(int[] nArray, int[] nArray2) {
        int n;
        long[] lArray = SelectorOperator.countl_m2(SelectorOperator.counts_m2(nArray));
        long[] lArray2 = SelectorOperator.countl_m2(SelectorOperator.counts_m2(nArray2));
        int n2 = Math.min(lArray.length, lArray2.length);
        double d = 1.0;
        for (n = 0; n < n2; ++n) {
            d *= (double)lArray[n];
            d /= (double)lArray2[n];
        }
        for (n = n2; n < lArray.length; ++n) {
            d *= (double)lArray[n];
        }
        for (n = n2; n < lArray2.length; ++n) {
            d /= (double)lArray2[n];
        }
        return d;
    }
}

