/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.ConstExpConst;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodelxml.coalescent.demographicmodel.ConstExpConstModelParser;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ConstExpConstModel
extends DemographicModel
implements Citable {
    private final Parameter N0Parameter;
    private final Parameter N1Parameter;
    private final Parameter growthRateParameter;
    private final Parameter timeParameter;
    private final Parameter epochParameter;
    private final ConstExpConst constExpConst;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ConstExpConstModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, boolean bl, Units.Type type) {
        this(ConstExpConstModelParser.CONST_EXP_CONST_MODEL, parameter, parameter2, parameter3, parameter4, parameter5, bl, type);
    }

    public ConstExpConstModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, boolean bl, Units.Type type) {
        super(string);
        if (parameter2 != null && parameter3 != null) {
            throw new RuntimeException("Only one of N1 and growthRate can be specified");
        }
        this.constExpConst = new ConstExpConst(parameter2 != null ? ConstExpConst.Parameterization.ANCESTRAL_POPULATION_SIZE : ConstExpConst.Parameterization.GROWTH_RATE, bl, type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.N1Parameter = parameter2;
        this.growthRateParameter = parameter3;
        if (parameter2 != null) {
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        } else {
            this.addVariable(parameter3);
            parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        }
        this.timeParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.epochParameter = parameter5;
        this.addVariable(parameter5);
        parameter5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.constExpConst.setEpochTime(this.epochParameter.getParameterValue(0));
        this.constExpConst.setN0(this.N0Parameter.getParameterValue(0));
        this.constExpConst.setTime1(this.timeParameter.getParameterValue(0) - this.getTimeOffset());
        if (this.N1Parameter != null) {
            this.constExpConst.setN1(this.N1Parameter.getParameterValue(0));
        } else {
            this.constExpConst.setGrowthRate(this.growthRateParameter.getParameterValue(0));
        }
        return this.constExpConst;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Constant-Exponential-Constant Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

