% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBeeGUTS.R
\name{plot.beeSurvData}
\alias{plot.beeSurvData}
\title{Plotting method for \code{beeSurvData} objects}
\usage{
\method{plot}{beeSurvData}(
  x,
  ...,
  xlab = "Time [d]",
  ylab1 = "Number of survivors",
  ylab2 = "Concentration",
  main = paste("Data from a", x$typeData, "test on", x$beeSpecies)
)
}
\arguments{
\item{x}{An object of class \code{beeSurvData}}

\item{...}{Additional parameters to generic plot function (not used)}

\item{xlab}{A character string for the label of the x-axis}

\item{ylab1}{A character string for the label of the y-axis of the survivor plots}

\item{ylab2}{A character string for the label of the y-axis of the concentration plots}

\item{main}{A character string for the title label plot}
}
\value{
A graphic with the input data
}
\description{
This is the generic \code{plot} S3 method for the \code{beeSurvData}
class. It plots the number of survivors as a function of time as well as the reconstructed
concentrations for \code{"Acute_Oral"} and \code{"Acute_Contact"} test types.
}
\examples{
data(betacyfluthrinChronic)
plot(betacyfluthrinChronic)
}
