% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CondProb.R
\name{CondProb}
\alias{CondProb}
\title{CondProb function}
\usage{
CondProb(D, y, z)
}
\arguments{
\item{D}{is an aligned list of transactions that was converted from any matrix n by d \code{mat} using
\code{D<-VecAlignment(mat)} where n is a number of transactions or samples
and d is a number of dimensions for each sample.}

\item{y}{is a d-dimensional vector.}

\item{z}{is a d-dimensional vector.}
}
\value{
This function returns the ratio \code{condP=count/countTotal}, which is the confidence of \code{y} given \code{z}.
\item{condP}{The confidence of \code{y} given \code{z} in \code{D}. }
\item{nD}{ The subset of \code{D} such that all transactions
have values at any position similar to \code{z[k]} when \code{z[k]} is not -1. }
\item{count}{ A number of transactions that have values at any position similar
to either \code{z[k]} or \code{y[k]} that is not -1. }
\item{countTotal}{ A number of transactions in \code{nD} }
}
\description{
This function computes a confidence value of \code{y} given \code{c}
or \code{conf(y|z)} from an aligned list \code{D}.
For any\code{y[i],z[j]}, their values are -1 by default.
The function computes the numbers of transactions
that satisfy the following conditions.
\enumerate{
\item All transactions must have values at any k position equal to \code{z[k]}
for any \code{z[k]} that is not -1.
Let \code{count} be the number of these transactions in \code{D}.
\item All transactions must have values at any k position equal to either \code{z[k]} or \code{y[k]}
that is not -1. Let \code{countTotal} be the number of these transactions in \code{D}.
}
}
\examples{
d=10 # dimensions of example vectors
z<-numeric(d)-1
y<-numeric(d)-1
y[1]<-c(1)
z[c(2,3)]<-c(1,1)
CondProb(BiCausality::D,y=y,z=z)$condP # conf(inx1 is 1 |inx 2,3 are 1 ) y|z

}
