
#' Realization of a simulated multivariate time series
#' 
#' @name Y
#' @title Simulated Multivariate Time Series
#' @docType data
#' @details \eqn{100 \times 3} multivariate time series distributed according to the generator matrix \link{A}.
#' @author Will Nicholson
NULL

#' Coefficient matrix for a stationary simulated multivariate time series
#' 
#' @name A
#' @title Generator for Simulated Multivariate Time Series
#' @docType data
#' @details Example generator matrix adapted from Table 3.2 of Gredenhoff and Karlsson (1997)
#' @references Gredenhoff, Mikael, and Sune Karlsson. "Lag-length selection in VAR-models using equal and unequal lag-length procedures." Computational Statistics 14.2 (1999): 171-187.
#' @author Will Nicholson
 NULL


#' Example multivariate macroeconomic time series
#' 
#' @name Y1
#' @title Example quarterly macroeconomic data
#' @docType data
#' @details US Macroeconomic Time Series: CPI, Federal Funds Rate, Gross Domestic Product, and M1.  Ranging from Q2 1959 to Q1 2025.  Procured from FRED, Federal Reserve Bank of St. Louis.
#' @author Will Nicholson
 NULL
