% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_multiscale}
\alias{simulate_multiscale}
\title{Simulate Multi-center Multi-scale Concentric Ring Patterns}
\usage{
simulate_multiscale(
  grid_size = 60,
  Ra_seq = seq(2.5, 20, by = 2.5),
  n_steps = 10,
  n_centers = 1,
  outer_start = 40,
  outer_end_factor = 1.2,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{grid_size}{Size of the spatial grid (default: 60)}

\item{Ra_seq}{Vector of inner circle radii (default: seq(2.5, 20, by = 2.5))}

\item{n_steps}{Number of outer radius shrinkage steps (default: 10)}

\item{n_centers}{Number of circle centers (default: 1)}

\item{outer_start}{Fixed starting outer radius (default: 40)}

\item{outer_end_factor}{Outer radius shrinks to this factor * Ra (default: 1.2)}

\item{seed}{Random seed for reproducible center placement (default: 123)}

\item{verbose}{Logical; if TRUE, show progress bar and messages (default: TRUE)}
}
\value{
List of data frames, each containing X, Y coordinates and signal_1, signal_2 binary signals
}
\description{
Generate multi-center, multi-scale concentric ring simulation data.
Creates patterns with inner circles and outer rings where the outer radius shrinks
from a fixed starting point to a factor of the inner radius across multiple steps.
}
\examples{
\donttest{
# Generate multi-center patterns with default parameters
patterns <- simulate_multiscale()

# Custom parameters
patterns <- simulate_multiscale(
  grid_size = 80,
  Ra_seq = seq(5, 25, by = 5),
  n_steps = 8,
  n_centers = 2,
  outer_start = 50
)
}
}
