% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_sgwt_kernels}
\alias{visualize_sgwt_kernels}
\title{Visualize SGWT kernels and scaling functions}
\usage{
visualize_sgwt_kernels(
  eigenvalues,
  scales = NULL,
  J = 4,
  scaling_factor = 2,
  kernel_type = "heat",
  lmax = NULL,
  eigenvalue_range = NULL,
  resolution = 1000
)
}
\arguments{
\item{eigenvalues}{Vector of eigenvalues from graph Laplacian}

\item{scales}{Vector of scales for the wavelets (if NULL, auto-generated)}

\item{J}{Number of scales to generate if scales is NULL (default: 4)}

\item{scaling_factor}{Scaling factor between consecutive scales (default: 2)}

\item{kernel_type}{Type of wavelet kernel ("mexican_hat" or "meyer", default: "mexican_hat")}

\item{lmax}{Maximum eigenvalue (optional, computed if NULL)}

\item{eigenvalue_range}{Range of eigenvalues to plot (default: full range)}

\item{resolution}{Number of points for smooth curve plotting (default: 1000)}
}
\value{
List containing the filter visualization plot and filter values
}
\description{
Visualize the scaling function and wavelet kernels used in SGWT
based on the eigenvalue spectrum and selected parameters
}
\examples{
\donttest{
# Generate some example eigenvalues
eigenvals <- seq(0, 2, length.out = 100)

# Visualize kernels with specific parameters
viz_result <- visualize_sgwt_kernels(
  eigenvalues = eigenvals,
  J = 4,
  scaling_factor = 2,
  kernel_type = "heat"
)
print(viz_result$plot)
}
}
