% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.r
\name{analyze_thermal_stats}
\alias{analyze_thermal_stats}
\title{Calculate Comprehensive Thermal Statistics}
\usage{
analyze_thermal_stats(img_obj, use_processed = TRUE)
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{use_processed}{Logical. If \code{TRUE} (default), calculates statistics on the 'processed' matrix
(where background is likely masked as NA). If \code{FALSE}, uses the 'raw' matrix.}
}
\value{
A 'BioThermR' object with the \code{stats} slot updated containing a data frame of results.
}
\description{
Computes a detailed set of summary statistics from the thermal matrix.
             Metrics include central tendency (Mean, Median, Peak Density), dispersion (SD, IQR, CV),
             and range (Min, Max, Quantiles). NA values (background) are automatically excluded.
}
\details{
The function calculates the following metrics:
         \itemize{
           \item \strong{Min/Max:} Extremities of the temperature distribution.
           \item \strong{Mean/Median:} Measures of central tendency.
           \item \strong{SD (Standard Deviation):} Absolute measure of spread.
           \item \strong{IQR (Interquartile Range):} Robust measure of spread (Q75 - Q25).
           \item \strong{CV (Coefficient of Variation):} Relative measure of spread (SD / Mean), useful for assessing thermal heterogeneity.
           \item \strong{Peak_Density:} The temperature value corresponding to the peak of the kernel density estimate (Mode).
         }
}
\examples{
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)
img <- analyze_thermal_stats(img)
}
