% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoltzMM.R
\name{marginpfvbm}
\alias{marginpfvbm}
\title{Marginal probability function for a fully-visible Boltzmann machine.}
\usage{
marginpfvbm(bvec, Mmat)
}
\arguments{
\item{bvec}{Vector of length n containing real valued bias parameters.}

\item{Mmat}{Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.}
}
\value{
Vector of length n containing the marginal probabilities of +1 in each coordinate.
}
\description{
Computes the marginal probabilities (for values = +1 in each coordinate) under under some specified bias vector and interaction matrix, specified by \code{bvec} and \code{Mmat}, respectively.
}
\examples{
#Compute the marginal probabilities under bvec and Mmat.
# Set the parameter values
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
marginpfvbm(bvec,Mmat)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
