% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bootstrapTest.R, R/print_bootstrapTest.R
\name{plot.bootstrapTest}
\alias{plot.bootstrapTest}
\alias{print.bootstrapTest}
\title{Plot and print the bootstrap test statistics distribution}
\usage{
\method{plot}{bootstrapTest}(
  x,
  xlim = NULL,
  breaks = NULL,
  legend.x = NULL,
  legend.y = NULL,
  ask = interactive(),
  plot_estimated_line = NULL,
  ...
)

\method{print}{bootstrapTest}(x, ...)
}
\arguments{
\item{x}{an object of class \code{bootstrapTest_independence} or \code{bootstrapTest}}

\item{xlim}{limits for the x-axis of the histogram}

\item{breaks}{breaks for the histogram}

\item{legend.x}{position of the legend on the x-axis}

\item{legend.y}{position of the legend on the y-axis}

\item{ask}{if \code{TRUE}, the user is asked to press Return to see the next
plot. Used only if \code{x} is an object of class \code{bootstrapTest_regression}.}

\item{plot_estimated_line}{Boolean describing whether to plot the estimated
regression line in case \code{x} is of class \code{"bootstrapTest_regression"},
i.e. output from \code{perform_regression_test}. By default,
\code{plot_estimated_line = NULL}, with the meaning that the plot is done
only if one estimated way of bootstrapping is given.}

\item{...}{additional arguments passed to the \code{hist} function
(in the case of the \code{plot} method) or ignored (in the case of the
\code{print} method).}
}
\value{
These functions have no return value and are called solely for their
side effects.
}
\description{
The \code{plot} and \code{print} methods work for objects of class \code{bootstrapTest}.
The \code{print} method prints the summary of the bootstrap test results.
The \code{plot} method plots the distribution of bootstrapped test statistics
as a histogram, with the true test statistic and the 95% quantile of the
bootstrapped test statistics highlighted. In the regression test case, the
estimated regression line is plotted as well.
}
\references{
Derumigny, A., Galanis, M., Schipper, W., & van der Vaart, A. (2025).
Bootstrapping not under the null?
ArXiv preprint, \doi{10.48550/arXiv.2512.10546}
}
\seealso{
\code{\link{perform_independence_test}, \link{perform_GoF_test},
\link{perform_regression_test}},
which are the functions that generate such object \code{x}.
}
