% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meansres.r
\name{SigScore}
\alias{SigScore}
\title{Calculate Signature Score for Cell Clusters}
\usage{
SigScore(seu, reduction, label, gclink, return.mean = TRUE)
}
\arguments{
\item{seu}{A Seurat object containing the single-cell RNA-seq data.}

\item{reduction}{A character string specifying the name of the dimensional reduction to use (e.g., "caesar").}

\item{label}{A character string specifying the column name in the Seurat object's metadata that contains the cell type or cluster labels.}

\item{gclink}{A data frame with two columns: `gene` and `cluster`, where `gene` corresponds to gene names and `cluster` corresponds to the associated cell cluster.}

\item{return.mean}{Logical, indicating whether to return the weighted mean signature score across all clusters. If \code{FALSE}, returns the score for each gene-cluster pair. Default is \code{TRUE}.}
}
\value{
If \code{return.mean = TRUE}, a numeric value representing the weighted mean signature score across all clusters. If \code{return.mean = FALSE}, a numeric vector containing the signature score for each gene-cluster pair.
}
\description{
This function calculates a signature score for cell clusters based on the embeddings of cells and genes in a Seurat object. The score measures how well the genes linked to specific clusters are separated in the embedding space. The function also supports returning a weighted mean score across all clusters.
}
\details{
The function computes the distance between gene embeddings and cell embeddings using a custom distance metric. It then calculates a score for each gene-cluster pair by evaluating how well the genes associated with a specific cluster are ordered in proximity to the cells of that cluster. The score is normalized between 0 and 1, where 1 indicates perfect separation.
}
\examples{
library(Seurat)
data(toydata)

seu <- toydata$seu

seu$cluster <- Idents(seu)

gclink <- data.frame(
    gene = c(
        "FBLN1", "CCDC80", "LYPD3", "MLPH", "HOXD9", "EGFL7",
        "HAVCR2", "IGSF6", "KRT5", "KRT6B", "CD79A", "DERL3",
        "CAV1", "AVPR1A", "CD3G", "CD3D"
    ),
    cluster = c(
        "CAFs", "CAFs", "Cancer Epithelial", "Cancer Epithelial",
        "Endothelial", "Endothelial", "Myeloid", "Myeloid",
        "Normal Epithelial", "Normal Epithelial", "Plasmablasts",
        "Plasmablasts", "PVL", "PVL", "T-cells", "T-cells"
    )
)

score <- SigScore(
    seu, reduction = "caesar", label = "cluster", gclink = gclink,
    return.mean = TRUE
)
print(score)

score <- SigScore(
    seu, reduction = "caesar", label = "cluster",
    gclink = gclink, return.mean = FALSE
)
print(score)

}
