% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\name{municipalities}
\alias{municipalities}
\alias{municipalities_25N}
\alias{municipalities_26N}
\title{Azorean municipalities}
\usage{
municipalities(crs = laea_azores_proj())

municipalities_25N()

municipalities_26N()
}
\arguments{
\item{crs}{Coordinate reference system (CRS) passed on to
\link[sf:st_transform]{st_transform()}. Defaults to a custom CRS centered on
the Azores, see \code{\link[=laea_azores_proj]{laea_azores_proj()}} for more details. Other possible
options are \code{"EPSG: 3035"} for ETRS89-extended / LAEA Europe or
\code{"EPSG:4326"} for WGS 84.}
}
\value{
A simple features (\link[sf:sf]{sf}) object with six fields:

\describe{
\item{\code{id}}{An unique identifier for the municipality. Follows the format
\verb{[DT][MN]}: DT is a two-digit id for the district and MN for the
municipality.}
\item{\code{municipality}}{Name of municipality.}
\item{\code{district}}{Name of district, coincides with the name of the island.}
\item{\code{area}}{Municipality area in hectares (ha).}
\item{\code{perimeter}}{Municipality perimeter in kilometers.}
\item{\code{n_parishes}}{Number of parishes in municipality.}
}
}
\description{
\code{\link[=municipalities]{municipalities()}} returns the boundaries of municipalities in the Azores.

\code{\link[=municipalities_25N]{municipalities_25N()}} returns the municipalities in the meter-based
projection PTRA08 / UTM zone 25N, i.e. those municipalities in the
western-most part of the archipelago: \emph{Ilha das Flores} and \emph{Ilha do Corvo}.

\code{\link[=municipalities_26N]{municipalities_26N()}} returns the municipalities in the meter-based
projection PTRA08 / UTM zone 26N, i.e. those municipalities in the Central
and Eastern groups of the archipelago.
}
\examples{
municipalities()
municipalities_25N()
municipalities_26N()

}
