% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-features.R
\name{plot_ED50_box}
\alias{plot_ED50_box}
\title{Plot a boxplot of ED50 values for different species and conditions.}
\usage{
plot_ED50_box(
  cbass_dataset,
  grouping_properties = c("Site", "Condition", "Species", "Timepoint"),
  drm_formula = "Pam_value ~ Temperature",
  Condition = "Condition",
  faceting = "~ Site",
  size_text = 12,
  size_points = 2
)
}
\arguments{
\item{cbass_dataset}{A data frame containing the dataset to be processed.}

\item{grouping_properties}{A character vector of column names to be used for grouping. Default: c("Site", "Condition", "Species", "Timepoint")}

\item{drm_formula}{A formula object specifying the dose-response model. Default: "Pam_value ~ Temperature".}

\item{Condition}{A character string specifying the condition to be used for coloring the plot. Default: "Condition".}

\item{faceting}{A formula specifying the faceting of the plot. Default: "~ Site".}

\item{size_text}{Default: 12. A formula specifying the faceting of the plot.}

\item{size_points}{Default: 2. A formula specifying the faceting of the plot.}
}
\value{
A ggplot object representing the boxplot of ED50 values.
}
\description{
Plot a boxplot of ED50 values for different species and conditions.
}
\examples{
# Example dataset
data(cbass_dataset)

# Example grouping properties
grouping_properties <- c("Site", "Condition", "Species", "Timepoint")

# Make ggplot object
boxplot_ED50 <- plot_ED50_box(cbass_dataset)

}
