% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_Ellipse.R
\name{create_Ellipse}
\alias{create_Ellipse}
\title{Create Ellipse}
\usage{
create_Ellipse(
  Latc,
  Lonc,
  Lmaj,
  Lmin,
  Ang = 0,
  Np = 100,
  dir = "cw",
  yx = FALSE
)
}
\arguments{
\item{Latc}{numeric, latitude of the ellipse centre in decimal degrees, or Y projected 
coordinate if \code{yx} is set to \code{TRUE}.}

\item{Lonc}{numeric, longitude of the ellipse centre in decimal degrees, or X projected 
coordinate if \code{yx} is set to \code{TRUE}.}

\item{Lmaj}{numeric, length of major axis.}

\item{Lmin}{numeric, length of minor axis.}

\item{Ang}{numeric, angle of rotation (0-360).}

\item{Np}{integer, number of points on the ellipse.}

\item{dir}{character, either \code{"cw"} (clockwise) or \code{"ccw"} (counterclockwise). 
Sets the order of points, only matters for \code{\link{create_CircularArrow}}.}

\item{yx}{Logical, if set to \code{TRUE} the input coordinates are projected.
Give Y as \code{Latc} and X as \code{Lonc}.}
}
\value{
Spatial object in your environment.
}
\description{
Create an ellipse.
}
\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#26-create-ellipse

El1=create_Ellipse(Latc=-61,Lonc=-50,Lmaj=500,Lmin=250,Ang=120)
El2=create_Ellipse(Latc=-72,Lonc=-30,Lmaj=500,Lmin=500)
Hash=create_Hashes(El2,spacing=2,width=2)
El3=create_Ellipse(Latc=-68,Lonc=-55,Lmaj=400,Lmin=100,Ang=35)

terra::plot(SmallBathy(),xlim=c(-3e6,0),ylim=c(0,3e6),breaks=Depth_cuts,
            col=Depth_cols,axes=FALSE,box=FALSE,legend=FALSE)
plot(st_geometry(Coast[Coast$ID=='All',]),col='grey',add=TRUE)
plot(st_geometry(El1),col=rgb(0,1,0.5,alpha=0.5),add=TRUE,lwd=2)
plot(st_geometry(El3),col=rgb(0,0.5,0.5,alpha=0.5),add=TRUE,border="orange",lwd=2)
plot(st_geometry(Hash),add=TRUE,col="red",border=NA)

}
\seealso{
\code{\link{create_Arrow}}, \code{\link{create_CircularArrow}}, \code{\link{create_Polys}},
\code{\link{add_Legend}}.
}
