#' Boundary Condition Dataset
#'
#' A dataset containing boundary condition data for computational fluid mechanics simulations.
#'
#' @format A data frame with variables:
#' \describe{
#'   \item{time}{Time variable (seconds)}
#'   \item{pressure}{Pressure values (Pa)}
#'   \item{temperature}{Temperature values (K)}
#'   \item{velocity}{Velocity components (m/s)}
#' }
#' @source Experimental measurements or numerical simulations
#' @name bcdata
#' @aliases bcdata
#' @usage data(bcdata)
#' @examples
#' data(bcdata)
#' head(bcdata)
#' summary(bcdata)
NULL
