% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFOeff.selectobd.R
\name{CFOeff.selectobd}
\alias{CFOeff.selectobd}
\title{Select the optimal biological dose (OBD) for the real single-drug trials}
\usage{
CFOeff.selectobd(target, txs, tys, tns, prior.para, mineff, effearly.stop)
}
\arguments{
\item{target}{the target DLT rate.}

\item{txs}{the cumulative counts of efficacy outcomes at all dose levels.}

\item{tys}{the cumulative counts of DLTs observed at all dose levels.}

\item{tns}{the cumulative counts of patients treated at all dose levels.}

\item{prior.para}{the prior parameters for two beta distributions, where set as \code{list(alp.prior.eff = 0.5, bet.prior.eff = 0.5)} by default.
\code{alp.eff.prior} and \code{bet.eff.prior}represent the parameters of the Jeffreys' prior distribution for the efficacy probability
at any dose level.This prior distribution is specified as Beta(\code{alpha.eff.prior}, \code{beta.eff.prior}).}

\item{mineff}{the lowest acceptable efficacy rate.}

\item{effearly.stop}{the threshold value for early stopping due to low efficacy. The trial would be terminated
early if \eqn{Pr(q_k<\psi |y_k,m_k \ge 3)} is smaller than the value of \code{effearly.stop} where \eqn{q_k, y_k} and \eqn{m_k}
are the efficacy probability, the number of efficacy outcomes and the number of patients at dose level \eqn{k}.
\eqn{\psi} is the the lowest acceptable efficacy rate which is set by \code{mineff} here.
By default, \code{effearly.stop} is set as \code{0.9}.}
}
\value{
The \code{CFOeff.selectobd()} function returns a list object comprising the following elements:
\itemize{
\item OBD: the selected OBD. \code{OBD = 99} indicates that all tested doses are overly toxic or having low efficacy.
\item MTD: MTD here is get by using function \code{CFO.selectmtd}. MTD is used as the upper bound of the admissible set.
\item OBD.probs: the probability that each dose level would be selected as OBD. The probability indicates that \eqn{q_k} corresponds
to dose level \eqn{k} being the highest in the admissible set. \eqn{q_k} is efficacy probability correspond to dose level k here.
}
}
\description{
Select the optimal biological dose (OBD) when the real single-drug trials is completed
}
\examples{
target <- 0.3; mineff<- 0.3
txs <- c(3, 1, 7, 11, 26); tys <- c(0, 0, 0, 0, 6); tns <- c(6, 3, 12, 17, 36)
prior.para = list(alp.prior.eff = 0.5, bet.prior.eff = 0.5)
effearly.stop <- 0.95
result <- CFOeff.selectobd(target, txs, tys, tns, prior.para, mineff, effearly.stop)
summary(result)
\donttest{
##Low efficacy
target <- 0.3; mineff<- 0.3
txs = c(0, 0, 0, 0, 0); tys = c(2, 1, 1, 1, 6); tns = c(36, 23, 22, 27, 36)
prior.para = list(alp.prior.eff = 0.5, bet.prior.eff = 0.5)
effearly.stop <- 0.95
result <- CFOeff.selectobd(target, txs, tys, tns, prior.para, mineff, effearly.stop)
summary(result)
}
\donttest{
##High toxicity
target <- 0.3; mineff<- 0.3
txs = c(3, 1, 7, 11, 26); tys = c(36, 23, 22, 27, 36); tns = c(36, 23, 22, 27, 36)
prior.para = list(alp.prior.eff = 0.5, bet.prior.eff = 0.5)
effearly.stop <- 0.95
result <- CFOeff.selectobd(target, txs, tys, tns, prior.para, mineff, effearly.stop)
summary(result)
}

}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
}
\author{
Jialu Fang, Ninghao Zhang, Wenliang Wang, and Guosheng Yin
}
