% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammatable.R
\name{gammatable}
\alias{gammatable}
\title{Generating table of threshold \eqn{\gamma_L} and \eqn{\gamma_R} in the calibration-free odds (CFO) design}
\usage{
gammatable(npatient, target, 
            para.prior = list(alp.prior = target, bet.prior = 1 - target))
}
\arguments{
\item{npatient}{the numbers of patients involved in the trial.}

\item{target}{the target DLT rate.}

\item{para.prior}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}
}
\value{
The \code{gammatable()} function returns a list object comprising the following elements:
\itemize{
\item gammatb.left: the table of threshold \eqn{\gamma_L} under different \eqn{m_L}
and \eqn{m_C} where \eqn{m_C} and \eqn{m_L} represent the number of patients at current dose level and left dose level.
\item gammatb.right: the table of threshold \eqn{\gamma_R} under different \eqn{m_R}
and \eqn{m_C} where \eqn{m_C} and \eqn{m_R} represent the number of patients at current dose level and right dose level.
}
}
\description{
Generate all the possible thresholds under different \eqn{m_C}, \eqn{m_L} and \eqn{m_R}
}
\note{
This function generate two matrices. \code{gammatb.left} contains the threshold \eqn{\gamma_L},
and \code{gammatb.right} contains the threhold \eqn{\gamma_R}. For matrix \code{gammatb.left}, the row index represent the number of patients
at left dose level, and the column index represent the number of patients at current dose level. For matrix \code{gammatb.right}, the row index represent the number of patients
at right dose level, and the column index represent the number of patients at current dose level.
For example, if you want to get the threshold \eqn{\gamma_L} in the case of \eqn{m_C = 12, m_L = 13}, you can reach it by \code{result$gammatb.left[13,12]}
}
\examples{
npatient <- 3; target <- 0.3
para.prior = list(alp.prior = target, bet.prior = 1 - target)
result <- gammatable(npatient, target, para.prior)
plot(result)
\donttest{#This example may cost you a long time to run
npatient <- 30; target <- 0.3
para.prior = list(alp.prior = target, bet.prior = 1 - target)
result <- gammatable(npatient, target, para.prior)
plot(result)
}
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066.
}
\author{
Jialu Fang, Ninghao Zhang, Wenliang Wang, and Guosheng Yin
}
