% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cerr.R
\name{cerr}
\alias{cerr}
\title{cerr function is used to generate a dataset where the error term follows cosine-based distributions}
\usage{
cerr(n, nr, p, dist_type, ...)
}
\arguments{
\item{n}{is the number of observations}

\item{nr}{is the number of observations with a different error distribution segment (the second block)}

\item{p}{is the dimension of the observation}

\item{dist_type}{is the cosine-based sampler to use:
\code{"cosine_random"}, \code{"cosine_rejection_sampling"}, or \code{"cosine_metropolis_hastings"}}

\item{...}{is additional arguments (reserved for compatibility; not used)}
}
\value{
X,Y,e
}
\description{
This cerr function generates a dataset with a specified number of observations and predictors,
along with a response vector that has an error term sampled from cosine-based distributions on [-pi/2, pi/2].
}
\examples{
set.seed(12)
data <- cerr(n = 1200, nr = 200, p = 5, dist_type = "cosine_random")
str(data)
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}

Guo, G., Sun, Y., Qian, G., & Wang, Q. (2022). LIC criterion for optimal subset selection in distributed interval estimation. \emph{Journal of Applied Statistics}, 50(9), 1900-1920. \doi{10.1080/02664763.2022.2053949}.

Chang, D., Guo, G. (2024). LIC: An R package for optimal subset selection for distributed data. \emph{SoftwareX}, 28, 101909.

Jing, G., & Guo, G. (2025). TLIC: An R package for the LIC for T distribution regression analysis. \emph{SoftwareX}, 30, 102132.

Chang, D., & Guo, G. (2025). Research on Distributed Redundant Data Estimation Based on LIC. \emph{IAENG International Journal of Applied Mathematics}, 55(1), 1-6.

Gao, H., & Guo, G. (2025). LIC for Distributed Skewed Regression. \emph{IAENG International Journal of Applied Mathematics}, 55(9), 2925-2930.

Zhang, C., & Guo, G. (2025). The optimal subset estimation of distributed redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 270–277.

Jing, G., & Guo, G. (2025). Student LIC for distributed estimation. \emph{IAENG International Journal of Applied Mathematics}, 55(3), 575–581.

Liu, Q., & Guo, G. (2025). Distributed estimation of redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 332–337.
}
