% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discordant.pairs.R
\name{discordant.pairs}
\alias{discordant.pairs}
\title{Count Discordant Pairs in Matched Case-Control Data}
\usage{
discordant.pairs(data, outcome, strata, variables = NULL)
}
\arguments{
\item{data}{A data frame containing the matched dataset.}

\item{outcome}{A character string giving the name of the binary outcome variable.}

\item{strata}{A character string giving the name of the variable that identifies matched strata or sets.}

\item{variables}{Optional. A character vector of variable names to evaluate for discordant pairs. If \code{NULL}, all categorical (factor or character) variables in \code{data} are used.}
}
\value{
A named numeric vector:
\itemize{
\item Each element corresponds to the number of discordant strata for one variable.
\item The final element, \code{total.valid.pairs}, gives the total number of strata that were eligible for evaluation.
}
}
\description{
This function identifies and counts discordant/non-informative pairs for categorical variables within matched case-control data.
It supports flexible matching designs, including 1:1 and 1:m, by evaluating each stratum individually.
Only strata with both case and control observations are included in the evaluation.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 7, Table 7.1

discordant.pairs(glow11m, outcome = 'fracture', strata = 'pair')

}
