% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_traffic.R
\docType{data}
\name{traffic}
\alias{traffic}
\title{Traffic data}
\format{
A data frame with 25 rows and four columns.
\describe{
\item{minutes}{the amount of unused red-light time in minutes}
\item{treatment}{the traffic light sequence}
\item{intersection}{the intersection the \code{treatment} was applied}
\item{time_of_day}{the time of the day the \code{treatment} was applied}
}
}
\source{
Kuehl, R. (2000)
}
\usage{
data(traffic)
}
\description{
Traffic light data for different light sequences, intersections, and times of
day.
}
\details{
A traffic engineer conducted a study to compare the total unused red-light
time for five different traffic light signal sequences. The experiment was
conducted with a Latin square design in which blocking factors were (1) five
intersections and (2) five time of day periods.
}
\examples{
attach(traffic)
np_anova(ordered_vars = rank(minutes),
predictor_vars = data.frame(treatment,intersection,time_of_day), uvw = 1)
}
\references{
Kuehl, R. (2000). Design of Experiments: Statistical Principles of Research Design and Analysis. Belmont, California: Duxbury Press.

Best, D. J. and Rayner, J. C. W. (2011). Nonparametric tests for Latin squares. NIASRA Statistics Working Paper Series, 11-11.
}
\keyword{LSD}
\keyword{datasets}
\keyword{traffic}
