% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_relay.R
\name{network_cof_relay}
\alias{network_cof_relay}
\title{Network cost of Failure for Relays}
\usage{
network_cof_relay(no_customers, kva_per_customer = "Default")
}
\arguments{
\item{no_customers}{Numeric. The number of customers
fed by an individual asset.}

\item{kva_per_customer}{Numeric. If the asset have an exceptionally high
demand per customer type in kVA per customer. A setting of \code{"Default"}
results in a multiplication factor of 1 (cf. table 18, page 90, CNAIM, 2021).}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for Relays
Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
Outputted in DKK.
}
\examples{
network_cof_relay(
no_customers = 100, kva_per_customer = 40)
}
