% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSEbeta.R
\name{MSEbeta}
\alias{MSEbeta}
\title{Calculate MSE values for different beta estimation methods}
\usage{
MSEbeta(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{The design matrix (observations).}

\item{Y}{The response vector.}

\item{alpha}{The significance level.}

\item{K}{The number of subsets.}

\item{nk}{The length of subsets (number of observations in each subset).}
}
\value{
A list containing:
\item{MSECOR}{The MSE of the COR beta estimator.}
\item{MSEAopt}{The MSE of the A-optimal beta estimator.}
\item{MSEDopt}{The MSE of the D-optimal beta estimator.}
\item{MSElic}{The MSE of the LIC beta estimator.}
}
\description{
Calculate MSE values for different beta estimation methods
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}
}
