\name{ConPwrNonMixGamma}

\alias{ConPwrNonMixGamma}

\title{
 Conditional Power (Non-Mixture-Gamma)
}

\description{
 Calculates the conditional power within
 the non-mixture model with Gamma type survival.
}

\usage{
 ConPwrNonMixGamma(data, cont.time, new.pat = c(0, 0),
                   theta.0 = 1, alpha = 0.05,
                   disp.data = FALSE, plot.km = FALSE)
}

\arguments{
 \item{data}{
  Data frame which consists of at least three columns with the group
  (two different expressions) in the first,
  status (1 = event, 0 = censored) in the second
  and event time in the third column.
 }
 \item{cont.time}{
  Period of time of continuing the trial.
 }
 \item{new.pat}{
  2-dimensional vector which consists of numbers of new patients
  who will be recruited each time unit
  (first component = group 1, second component = group 2)
  with default at (0, 0).
 }
 \item{theta.0}{
  Originally postulated clinically relevant difference
  (hazard ratio = hazard of group 2 / hazard of group 1)
  with default at 1.
 }
 \item{alpha}{
  Significance level for conditional power calculations
  with default at 0.05.
 }
 \item{disp.data}{
  Logical value indicating if all calculated data should be displayed
  with default at FALSE.
 }
 \item{plot.km}{
  Logical value indicating if Kaplan-Meier curves
  and estimated survival curves according to
  the non-mixture model with Gamma type survival should be plotted
  with default at FALSE.
 }
}

\details{
 This function calculates the conditional power within
 the non-mixture model with Gamma type survival, i. e.
 \deqn{S(t) = c^(\Gamma^(0)(a, b t))}
 for all \eqn{t \ge 0}, \eqn{a > 0}, \eqn{b > 0} and \eqn{0 < c < 1}
 with \eqn{\Gamma^(0)} being
 the regularized incomplete Gamma function of the upper bound,
 and plots the conditional power curve.
 
 Optionally, further data will be displayed.
 This includes data from interim analysis, log-likelihoods, AICs,
 calculated estimators and further patient times.
 
 Moreover, it is possible to plot the Kaplan-Meier curves
 and the estimated survival curves according to
 the non-mixture model with Gamma type survival.
}

\value{
 See Details.
 
 Returns a list which consists of the following components:
 \item{a1.hat}{
  estimated shape parameter of group 1
 }
 \item{b1.hat}{
  estimated rate parameter of group 1
 }
 \item{c1.hat}{
  estimated survival fraction of group 1
 }
 \item{a2.hat}{
  estimated shape parameter of group 2
 }
 \item{b2.hat}{
  estimated rate parameter of group 2
 }
 \item{c2.hat}{
  estimated survival fraction of group 2
 }
 \item{theta.hat}{
  estimated hazard ratio
   = \eqn{log(}estimated survival fraction of group 2\eqn{)}
      / \eqn{log(}estimated survival fraction of group 1\eqn{)}
 }
 \item{gamma.theta.0}{
  conditional power
 }
}

\note{
 There are several mechanisms to ensure that no illegal operations will be done
 and maximum likelihood calculations will be executed stable.
 That is why there should not be too less data in the data frame,
 for example one patient of each group and both being censored.
}

\author{
 Andreas Kuehnapfel
}

\references{
 Kuehnapfel, A. (2013).
 Die bedingte Power in der Ueberlebenszeitanalyse.
}

\seealso{
 \code{\link{CP}} \cr
 \code{\link{GenerateDataFrame}} \cr
 \code{\link{test}}
}

\examples{
 # data frame 'test' generated by 'GenerateDataFrame'
 
 # conditional power calculations
 # within the non-mixture model with Gamma type survival
 ConPwrNonMixGamma(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
                   theta.0 = 0.75, alpha = 0.05,
                   disp.data = TRUE, plot.km = TRUE)
}