% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_ffa_screen_plot.R
\name{ch_ffa_screen_plot}
\alias{ch_ffa_screen_plot}
\title{FFA screening plot}
\usage{
ch_ffa_screen_plot(
  df,
  stn = "unspecified",
  mtitle = "",
  n = 12,
  m = 0,
  M = 2,
  offset = 0,
  mcol = c("orange", "gray70", "red")
)
}
\arguments{
\item{df}{dataframe with date of event [maxdate] and annual maximum [amax]}

\item{stn}{stationID}

\item{mtitle}{title for plot}

\item{n}{default is 12, number of colours for number of months}

\item{m}{smallest angle in radians parameter for generating circular colours default = 0}

\item{M}{largest angle in radians parameter for generating circular colours default = 2 (*pi)}

\item{offset}{the zero in radians, default is 0.}

\item{mcol}{array of three colours, default is c("orange", "gray70", "red") use to outline or
emphasize low outliers, normal, and high outliers.}
}
\value{
a list containing
\itemize{
\item Station if specified else "unspecified"
\item number of amax events
\item array of amax magnitudes
\item array of outlier codes (1 = low, 2 = not, 3 = high outlier)
}
}
\description{
Generates a flood frequency plot with symbols indicating whether an observation is a
high or low outlier, and colour symbols indicating month of the year in which the flood
occurred.
}
\examples{
\donttest{
# Not tested automatically as can be very slow to execute
data(CAN05AA008)
amax <- ch_sh_get_amax(CAN05AA008)
ch_ffa_screen_plot(amax)}
}
\references{
Cohn, T. A., J. F. England, C. E. Berenbrock, R. R. Mason, J. R.
Stedinger and J. R. Lamontagne (2013). "A generalized Grubbs‐Beck test statistic
for detecting multiple potentially influential low outliers in flood series."
Water Resources Research 49(8): 5047-5058 10.1002/wrcr.20392: 10.1002/wrcr.20392.
}
