% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glasso.R
\name{plot.CVglasso}
\alias{plot.CVglasso}
\title{Plot CVglasso object}
\usage{
\method{plot}{CVglasso}(x, type = c("line", "heatmap"), footnote = TRUE,
  ...)
}
\arguments{
\item{x}{class object CVglasso}

\item{type}{produce either 'heatmap' or 'line' graph}

\item{footnote}{option to print footnote of optimal values. Defaults to TRUE.}

\item{...}{additional arguments.}
}
\description{
Produces a plot for the cross validation errors, if available.
}
\examples{
# generate data from a sparse matrix
# first compute covariance matrix
S = matrix(0.7, nrow = 5, ncol = 5)
for (i in 1:5){
 for (j in 1:5){
   S[i, j] = S[i, j]^abs(i - j)
 }
}

# generate 100 x 5 matrix with rows drawn from iid N_p(0, S)
Z = matrix(rnorm(100*5), nrow = 100, ncol = 5)
out = eigen(S, symmetric = TRUE)
S.sqrt = out$vectors \%*\% diag(out$values^0.5)
S.sqrt = S.sqrt \%*\% t(out$vectors)
X = Z \%*\% S.sqrt

# produce line graph for CVglasso
plot(CVglasso(X))

# produce CV heat map for CVglasso
plot(CVglasso(X), type = 'heatmap')
}
