% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.calibration_simplex.R
\name{plot.calibration_simplex}
\alias{plot.calibration_simplex}
\title{Plot Calibration Simplex}
\usage{
\method{plot}{calibration_simplex}(
  x,
  true_error = TRUE,
  error_scale = 0.3,
  min_bin_freq = 10,
  plot_error_scale = TRUE,
  scale_area = NULL,
  indicate_bins = TRUE,
  category_labels = c("1", "2", "3"),
  use_pvals = FALSE,
  alphas = c(0.1, 0.01),
  colors = c("blue", "orange", "red", "black"),
  ...
)
}
\arguments{
\item{x}{Object of class \code{calibration_simplex}}

\item{true_error}{Logical, specifying whether to use true miscalibration errors or approximate miscalibration errors.}

\item{error_scale}{A number specifying the magnitude of the miscalibration errors (greater 0, usually should be less than 1,
cf. note below).}

\item{min_bin_freq}{A number. Lower bound for (absolute) frequencies, i.e. how many observations have to lie in a bin
for it to be plotted.}

\item{plot_error_scale}{Logical, specifying whether to plot a scale showing the magnitude of miscalibration errors.}

\item{scale_area}{Optional. A number by which the areas of the points are scaled. Use if points are to small or to big.}

\item{indicate_bins}{Logical, specifying whether to connect points to their respective bin (center of hexagon).}

\item{category_labels}{A vector of length 3 containing the category names, e.g. \code{c("1","2","3")} (default)}

\item{use_pvals}{Logical, determines whether multinomial p-values are used for uncertainty quantification, see details.}

\item{alphas}{Vector of length 2 with values 1 > \code{alphas[1]} > \code{alphas[2]} >= 0.0001. Only relevant if \code{use_pvals = TRUE}.}

\item{colors}{Vector of length 4 specifying colors, defaults to \code{c("blue","orange","red","black")}. 
Coloring used for p-values, see details. Only relevant if \code{use_pvals = TRUE}.}

\item{...}{Arguments concerning the title (e.g. \code{main}, \code{cex.main}, \code{col.main} and \code{font.main})
and subtitle (e.g. \code{sub}, \code{cex.sub}, \code{col.sub} and \code{font.sub}) may be passed here.}
}
\description{
Plot Calibration Simplex
}
\details{
If multinomial p-values are used (\code{use_pvals = TRUE}), the dots are colored in the following way:
\itemize{
  \item \code{colors[1]} (blue by default): p-value greater \code{alphas[1]} (0.1 by default).
  \item \code{colors[2]} (orange by default): p-value between \code{alphas[1]} and \code{alphas[2]} (0.1 and 0.01 by default)
  \item \code{colors[3]} (red by default): p-value less than \code{alphas[2]} (0.01 by default)
  \item \code{colors[4]} (black by default): p-value is exactly 0. This only happens if a category which is assigned 0 probability realizes.
}
Many small p-values (orange and red dots) indicate miscalibrated predictions, whereas many blue dots indicate that the predictions 
may in fact be calibrated. WARNING: The use of the multinomial p-values is more of an experimental feature and may not yield reliable 
p-values, especially if \code{n} is small.
For details regarding the calculation of the p-values see also \code{\link{calibration_simplex}}.
}
\note{
For details on the meaning of the error scale, cf. Wilks, 2013, especially Fig. 2. Note that the miscalibration error in
each category is in "probability units" (as it is the average difference in relative frequency and forecast probability
in each bin).
}
