% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conda_support.R
\name{track_conda_env}
\alias{track_conda_env}
\title{Track Conda Environment}
\usage{
track_conda_env(env_name = NULL, output_file, use_mamba = FALSE, registry_file)
}
\arguments{
\item{env_name}{Character. Name of conda environment. If NULL, uses active environment.}

\item{output_file}{Character. Path to save environment file (required).}

\item{use_mamba}{Logical. Use mamba instead of conda. Default FALSE.}

\item{registry_file}{Character. Path to conda registry (required).}
}
\value{
List containing environment information
}
\description{
Export and track a conda environment specification for reproducibility.
Works with both conda and mamba.
}
\examples{
\dontrun{
# Track currently active conda environment
track_conda_env(output_file = tempfile(fileext = ".yml"),
                registry_file = tempfile(fileext = ".json"))

# Track specific environment
track_conda_env(env_name = "bioinfo_env",
                output_file = tempfile(fileext = ".yml"),
                registry_file = tempfile(fileext = ".json"))

# Use mamba instead
track_conda_env(use_mamba = TRUE,
                output_file = tempfile(fileext = ".yml"),
                registry_file = tempfile(fileext = ".json"))
}
}
