% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmegaClass.R
\name{Omega}
\alias{Omega}
\title{Create an Omega instance with validation}
\usage{
Omega(
  Name = character(),
  InitialOmega = 1,
  State = "Present",
  Frozen = FALSE,
  StParmName = character(),
  PMLStructure = character()
)
}
\arguments{
\item{Name}{A character string specifying the name of the Omega.}

\item{InitialOmega}{Numeric specifying the initial value of the Omega. Default value is 1.}

\item{State}{Character specifying the presence of the Omega. Possible values are:
\itemize{
\item \code{None} The Omega does not exist in the specified \code{PMLStructures}.
\item \code{Present} The Omega exists in the specified \code{PMLStructures} (the default).
\item \code{Searched} The presence of the Omega is searched.
}}

\item{Frozen}{A logical value indicating whether the Omega is frozen or not.}

\item{StParmName}{A character string specifying the corresponding structural parameter name.}

\item{PMLStructure}{PML structure current omega belongs to.}
}
\value{
An Omega instance.
}
\description{
This function creates an Omega instance with the given parameters and validates it.
}
\examples{
nV <- Omega("nV")

}
\seealso{
\code{\link[=list_Omegas]{list_Omegas()}}

Functions used for Omega specification: 
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Omega}()}
}
\concept{Omegas}
