% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\name{extraDoseNames}
\alias{extraDoseNames}
\title{Return extra dose names}
\usage{
extraDoseNames(model)
}
\arguments{
\item{model}{Model object}
}
\value{
Character vector of extra dose names
}
\description{
Use to return extra dose names for model object
}
\examples{
data <- pkData
data$II <- 24
data$ADDL <- 1

model <-
pkmodel(
  parameterization = "Clearance",
  numCompartments = 2,
  data = data,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir())
addDoseCycle(
  model,
  name = "A1",
  amount = 30000,
  II = 24,
  type = "ADDL",
  colName = "ADDL")

extraDoseNames(model)

}
