% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_estimation.r
\name{profilePertubate}
\alias{profilePertubate}
\title{Executes an NLME profile perturbation}
\usage{
profilePertubate(
  hostPlatform,
  params = NULL,
  profiles,
  model = NULL,
  sortColumns = SortColumns(""),
  scenarios = list(),
  runInBackground = FALSE
)
}
\arguments{
\item{hostPlatform}{How to execute the run(NlmeParallelHost)}

\item{params}{Engine parameters(NlmeEngineExtraParams)}

\item{profiles}{Profiles to perturbate(ProfileParameters)}

\item{model}{PK/PD model}

\item{sortColumns}{Optional list of columns to sort and fit(SortColumns)}

\item{scenarios}{Optional list of scenarios to fit(NlmeScenario)}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt(Bool)}
}
\value{
List of results from NLME execution.
}
\description{
Executes an NLME profile perturbation
}
\examples{
\dontrun{
  model <- pkmodel(
    parameterization = "Clearance",
    numCompartments = 2,
    data = pkData,
    ID = "Subject",
    Time = "Act_Time",
    A1 = "Amount",
    CObs = "Conc",
    workingDir = tempdir()
  )

  params <- NlmeEngineExtraParams(
    method = 3,
    numIterations = 1
  )

  host <- hostParams(
    sharedDirectory = tempdir(),
    parallelMethod = "MULTICORE",
    hostName = "local",
    numCores = 4
  )

  profile1 <- ProfileVar(
    "tvV",
    9.548,
    "-2,2"
  )

  profile2 <- ProfileVar(
    "tvCl",
    0.919,
    "-0.5,1.5"
  )

  profiles <- ProfileParameters(
    "USE_DELTA",
    c(profile1, profile2)
  )

  job <- profilePertubate(
    hostPlatform = host,
    params = params,
    profiles = profiles,
    model = model
  )
}
}
\keyword{internal}
