get_mappedCovariates <- function(CovModelNames, input, cols1.txt) {
  mappedCovariates <- c()
  if (length(CovModelNames) > 0) {
    for (CovModelName in CovModelNames) {
      CovInputName <- lookupMappedColumn(
        inputColnames = colnames(input),
        mapping = cols1.txt,
        colName = CovModelName,
        warn = FALSE,
        pattern = paste0("^\\W*covr\\W*\\(\\W*", CovModelName)
      )
      if (CovInputName != "") {
        names(CovInputName) <- CovModelName
        # mappedCovariates named vector has the names of the model covariates in the values
        # and names of columns in the names
        mappedCovariates <- c(mappedCovariates, CovInputName)
      }
    }
  }

  mappedCovariates
}
