% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_volumes.R
\name{calculate_volumes}
\alias{calculate_volumes}
\title{Calculate Segment Volumes Over Time}
\usage{
calculate_volumes(data, segments)
}
\arguments{
\item{data}{A data frame containing adjusted marker coordinates in centimeters, with columns 'Timeframe', 'Marker', 'X', 'Y', 'Z'.}

\item{segments}{A list of character vectors, each containing marker names defining a segment.}
}
\value{
A data frame with columns 'Timeframe', 'Segment', 'Volume'.
}
\description{
Calculates the volumes of specified segments over time using convex hulls.
}
\details{
Coordinates should be in centimeters to ensure correct volume units (cm³).
}
\examples{
# Define segments (e.g., quadrants of the chest)
segments <- list(
  UL = c("M01", "M02", "M03", "M04"),
  UR = c("M05", "M06", "M07", "M08")
)

# Assume 'adjusted_data' is the data frame with adjusted marker positions in cm
data('sample_data')
reformat_data <- reformat_marker_data(head(sample_data))
adjusted_data <- adj_position(reformat_data)
volumes_df <- calculate_volumes(adjusted_data, segments)
head(volumes_df)

}
