% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{family_name_df}
\alias{family_name_df}
\title{Chinese Surnames and National Frequency (1930–2008)}
\format{
A data frame with 1806 observations and 7 variables:
\describe{
  \item{surname}{Chinese surname (character)}
  \item{compound}{Indicates if the surname is compound (numeric)}
  \item{initial}{Initial letter of surname in Pinyin (character)}
  \item{initial.rank}{Rank of the initial letter (numeric)}
  \item{n.1930_2008}{Estimated number of people with the surname (1930–2008) (numeric)}
  \item{ppm.1930_2008}{Relative frequency per million (1930–2008) (numeric)}
  \item{surname.uniqueness}{Surname uniqueness score (numeric)}
}
}
\source{
Data taken from the ChineseNames package version 2023.8
}
\usage{
data(family_name_df)
}
\description{
This dataset, family_name_df, is a data frame containing 1,806 Chinese surnames along with
their frequency and distribution across China. The dataset includes 1806 observations and
7 variables, covering information such as whether a surname is compound, its initial,
frequency ranks, and relative frequency between 1930 and 2008. This dataset is useful
for sociolinguistic analysis, demography, and historical population studies.
}
\details{
The dataset name has been kept as 'family_name_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChinAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
