\name{axialnntsmanifoldnewtonestimationgradientstopknownmusymmetric}
\alias{axialnntsmanifoldnewtonestimationgradientstopknownmusymmetric}
\title{
Parameter estimation for axial symmetric NNTS distributions with known location angle gradient stop
}
\description{
Computes the maximum likelihood estimates of the parameters of an axial symmetric NNTS distribution with known location angle, using a Newton algorithm on the hypersphere and considering a maximum number of iterations determined by a constraint in terms of the norm of the gradient
}
\usage{
axialnntsmanifoldnewtonestimationgradientstopknownmusymmetric(data, muknown=0, M = 0, 
iter = 1000, initialpoint = FALSE, cinitial,gradientstop=1e-10)
}
\arguments{
  \item{data}{Vector of axial angles in radians}
  \item{muknown}{Value of the known location angle}
  \item{M}{Number of components in the NNTS axial model}
  \item{iter}{Number of iterations}
  \item{initialpoint}{TRUE if an initial point for the optimization algorithm for the axial NNTS density will be used}
  \item{cinitial}{Vector of size M+1. The first element is real and the next M elements are complex (values for $c_0$ and $c_1, ...,c_M$). The sum of the squared moduli of the parameters must be equal to 1/pi. This is the vector of parameters for the general (asymmetric) NNTS axial density}
  \item{gradientstop}{The minimum value of the norm of the gradient to stop the Newton algorithm on the hypersphere}
}

\value{A list with 13 elements:
\item{cestimatesmuknown}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the symmetric NNTS axial model with known location angle}
\item{muknown}{Known value of the location angle of the symmetric NNTS axial model}
\item{loglikmuknown}{Optimum log-likelihood value for the symmetric NNTS axial model with known location angle}
\item{AICmuknown}{Value of Akaike's Information Criterion for the symmetric NNTS axial model with known location angle}
\item{BICmuknown}{Value of Bayesian Information Criterion for the symmetric NNTS axial model with known location angle}
\item{gradnormerrormuknown}{Gradient error after the last iteration for the estimation of the parameters of the symmetric NNTS axial model with known location angle}
\item{cestimatesmuunknown}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the general (non-symmetric) NNTS axial model with unknown location angle}
\item{loglikmuunknown}{Optimum log-likelihood value for the general (non-symmetric) NNTS axial model with unknown location angle}
\item{AICmuunknown}{Value of Akaike's Information Criterion for the general (non-symmetric) NNTS axial model with unknown location angle}
\item{BICmuunknown}{Value of Bayesian Information Criterion for the general (non-symmetric) NNTS axial model with unknown location angle}
\item{gradnormerrormuunknown}{Gradient error after the last iteration for the estimation of the parameters of the general (non-symmetric) NNTS axial model with unknown location angle}
\item{loglikratioformuknown}{Value of the likelihood ratio test statistic for known location angle}
\item{loglikratioformuknownpvalue}{Value of the asymptotic chi squared p-value of the likelihood ratio test statistic for known location angle}
}

\author{
Juan Jose Fernandez-Duran and Maria Mercedes Gregorio-Dominguez
}
\references{
Fernandez-Duran, J.J. and Gregorio-Dominguez, M.M. (2025). Multimodal distributions for circular axial data. arXiv:2504.04681 [stat.ME] (available at https://arxiv.org/abs/2504.04681)

Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME] (available at https://arxiv.org/abs/2412.19501)
}
\examples{
data(Datab2fisher)
feldsparsangles<-Datab2fisher
feldsparsangles<-feldsparsangles$orientations*(pi/180)
resfeldsparknownanglesymmetric<-axialnntsmanifoldnewtonestimationgradientstopknownmusymmetric(
data=feldsparsangles, muknown=pi/3, M = 3, iter =1000, gradientstop=1e-10)
resfeldsparknownanglesymmetric
hist(feldsparsangles,breaks=seq(0,pi,pi/7),xlab="Orientations (radians)",freq=FALSE,
ylab="",main="",ylim=c(0,.8),axes=FALSE)
axialnntsplot(resfeldsparknownanglesymmetric$cestimatesmuunknown[,2],3,add=TRUE)
axialnntsplot(resfeldsparknownanglesymmetric$cestimatesmuknown[,2],3,add=TRUE,lty=2)
axis(1,at=c(0,pi/2,pi),labels=c("0",expression(pi/2),expression(pi)),las=1)
axis(2)
}

