% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sw_period.R
\name{extract_sw_period}
\alias{extract_sw_period}
\title{Extract contiguous sleep or wake periods from a labeled minute series}
\usage{
extract_sw_period(labeled_df, target_state = 1, min_len = 30)
}
\arguments{
\item{labeled_df}{A \code{data.frame} containing at least:
\itemize{
\item \code{Activity} — numeric minute-level activity.
\item \code{label.sw} — binary sleep/wake label per minute (\code{1} = sleep,
\code{0} = wake). \code{NA} values are treated as breaks between episodes.
}}

\item{target_state}{Integer \code{0} or \code{1}. Use \code{0} to extract sleep episodes,
\code{1} to extract wake episodes. Default is \code{1}.}

\item{min_len}{Integer minimum episode length \strong{in minutes} (i.e., number of
consecutive samples) required to keep an episode. Default is \code{30}.}
}
\value{
A \strong{list} of numeric vectors. Each element is the \code{Activity} values
for one qualifying episode of the requested state. If no episode qualifies,
returns an empty list (\code{list()}).
}
\description{
Splits a minute-level, labeled time series into contiguous episodes of a
target state (sleep or wake) and returns the \strong{activity vectors} for those
episodes whose length is at least \code{min_len} minutes.
}
\details{
The function uses run-length encoding over \code{label.sw} to identify contiguous
episodes. Any \code{NA} in \code{label.sw} is converted to a sentinel and treated as a
hard break (i.e., episodes do not cross \code{NA} gaps). Length filtering is
applied on the number of minutes (rows) per episode.
}
\seealso{
\code{\link[=sleep_detection]{sleep_detection()}}

#' @export
}
