% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_acti_file.R
\name{import_acti_file}
\alias{import_acti_file}
\title{Import actigraphy with header stripping and harmonized \code{Activity}}
\usage{
import_acti_file(
  file,
  date_col,
  time_col,
  activity_cols,
  id = NULL,
  keep_extra = FALSE,
  drop_original_activity_cols = TRUE
)
}
\arguments{
\item{file}{Character path to the actigraphy file.}

\item{date_col, time_col}{Character names of the date and time columns in \code{file}.}

\item{activity_cols}{Character vector of candidate activity columns; the first
that exists will be used and renamed to \code{Activity}.}

\item{id}{Optional subject id (character). Defaults to the filename stem.}

\item{keep_extra}{Logical; if \code{FALSE} keeps only \verb{id, Date, Time, Activity},
otherwise preserves extra columns present in the file.}

\item{drop_original_activity_cols}{Logical; if TRUE, drop the original activity}
}
\value{
A \code{data.frame} with at least columns \code{id}, \code{Date}, \code{Time}, \code{Activity}.
}
\description{
Reads a CSV/TSV, automatically strips any leading header lines, selects user
specified \code{Date} and \code{Time} columns, and harmonizes one chosen activity
column to the canonical name \code{Activity}. Adds an \code{id} (defaults to the file
stem if not supplied).
}
\details{
Internally uses \code{data.table::fread()} with automatic header detection
(skips lines before the first row that looks like a header). No time zone
conversion is performed.
}
\seealso{
\code{\link[=screen_wear]{screen_wear()}}
}
