test_that("all functions", {

  # csv <- system.file("extdata", "NHANES-11111.csv", package = "CircaCP")
  # if (!nzchar(csv) || !file.exists(csv)) {
  #   # build a 3-day, 1-min synthetic CSV
  #   mpd <- 1440L; ndays <- 3L; n <- mpd * ndays
  #   Dates <- as.character(as.Date("2025-01-01") + ((0:(n-1)) %/% mpd))
  #   modm  <- (0:(n-1)) %% mpd
  #   H <- modm %/% 60L; M <- modm %% 60L
  #   Times <- sprintf("%02d:%02d:%02d", H, M, 0L)
  #   set.seed(1)
  #   Activity <- pmax(0, 1000 + 900 * cos(2*pi*(modm - 16*60)/mpd) + rnorm(n, 0, 150))
  #   csv_tmp <- tempfile(fileext = ".csv")
  #   write.csv(data.frame(Date = Dates, Time = Times, activity = Activity),
  #             csv_tmp, row.names = FALSE)
  #   csv <- csv_tmp
  # }
  csv <- system.file("extdata", "NHANES_11111.csv", package = "CircaCP")
  skip_if(!nzchar(csv) || !file.exists(csv), "extdata file missing in install")

  DF <- import_acti_file(csv, "Date", "Time", "MIMS")




  # df <- import_acti_file(
  #   file          = "tests/NHANES-11111.csv",
  #   date_col      = "Date",
  #   time_col      = "Time",
  #   activity_cols = "activity",  # you pick which to keep
  #   keep_extra    = FALSE       # set TRUE to keep all columns
  # )


  out <- screen_wear(
    DF,
    min_days     = 5,
    max_zero_run = 200
  )
  if (out$status =="ok") {
    CleanDF = out$clean_df
  }

  NewDF = sleep_detection(CleanDF,thr = 0.4,dist='ZAG')

  # ggplot(newdf, aes(x = 1:length(Activity_norm))) +
  #   geom_line(aes(y = Activity_norm), color ="grey",linewidth = 0.35, alpha = 0.8) +
  #   geom_line(aes(y = label.cos), color = "blue", linewidth = 0.7) +
  #   geom_line(aes(y = label.sw), color = "green", linewidth = 0.7)+
  #   geom_line(aes(y = cosinor/1.5), color = "pink", linewidth = 0.7) +
  #   labs( x = "Time", y = "Activity Levels",
  #         title = unique(newdf$id)) +theme_bw(base_size = 12)

  metrics = extract_sleep_metrics(NewDF)

  #wake_periods = extract_sw_period(NewDF, target_state = 1, min_len = 30)
  #sleep_periods = extract_sw_period(NewDF, target_state = 0, min_len = 30)



  })
