% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRO.R
\name{PRO}
\alias{PRO}
\title{Proportional rule}
\usage{
PRO(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the PRO rule. If \code{name = TRUE}, the name of the function (PRO) as a character string.
}
\description{
This function returns the awards vector assigned by the proportional rule (PRO) to a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{D=\sum_{i \in N} d_i\ge E}.

The proportional rule (PRO) distributes awards proportional to claims, that is,
\deqn{\text{PRO}(E,d)=\frac{E}{D}d.}
}
\examples{
E=10
d=c(2,4,7,8)
PRO(E,d)
}
\references{
Aristotle, Ethics, Thompson, J.A.K., tr. 1985. Harmondsworth: Penguin.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{APRO}, \link{axioms}.
}
