% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAStringSetTPR.R
\name{DNAStringSetTPR}
\alias{DNAStringSetTPR}
\title{Curing of biological sequences}
\usage{
DNAStringSetTPR(SEQs, PrimerF, PrimerR)
}
\arguments{
\item{SEQs}{file with fasta format containing biological sequences that are to be cleaned.}

\item{PrimerF}{dnastring containing the foward primer/vector sequences to be removed.}

\item{PrimerR}{dnastring containing the reverse primer/vector sequences to be removed.}
}
\value{
clean biological sequences and visualization of the alignments
}
\description{
Curates biological sequences of two restriction enzyme primers or cloning vectors.This cleaning is required for techniques such as cDNA-AFLP.This cleaning is required for techniques such as cDNA-AFLP.
}
\examples{
SEQs = readDNAStringSet(system.file("sequences","SeqInputTPR.fasta", package = "CleanBSequences"))
PrimerR= DNAString ("GACTGCGTACCATGC")
PrimerF = DNAString("GATGAGTCCTGACCGAA")
DNAStringSetTPR (SEQs,PrimerF,PrimerR)
}
\author{
Florencia I Pozzi, Silvina A. Felitti
}
