% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPrimersRemove.R
\name{TwoPrimerRemove}
\alias{TwoPrimerRemove}
\title{Clean biological secuences}
\usage{
TwoPrimerRemove(SEQs, PrimerF, PrimerR)
}
\arguments{
\item{SEQs}{DNAString containing biological sequences that are to be cleaned.}

\item{PrimerF}{dnastring containing the foward primer/vector sequences to be removed.}

\item{PrimerR}{dnastring containing the reverse primer/vector sequences to be removed.}
}
\value{
clean biological sequences and visualization of the alignments
}
\description{
Curates biological sequences of two restriction enzyme primers or cloning vectors.This cleaning is required for techniques such as cDNA-AFLP.
}
\examples{
SEQs = DNAString(paste("ACTTTCTGCTGCTTGTGGTCGCAATCAGAGTCCTGATGATGAGTCCTGA",
"CCGAACCCTTTTTCTCCGTCATCCGTTGGTCCATGGTACGCAATCAGAG", sep = ""))
PrimerF = DNAString("GATGAGTCCTGACCGAA")
PrimerR = DNAString("GACTGCGTACCATGC")
TwoPrimerRemove (SEQs,PrimerF,PrimerR)
}
\author{
Florencia I Pozzi, Silvina A. Felitti
}
