% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{sdii}
\alias{sdii}
\title{Simple precipitation intensity index}
\usage{
sdii(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{daily precipitation, mm}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
precipitation, mm
}
\description{
Sum of precipitation in wet days (days with >1mm of precipitation), and dividing that by the number of wet days in the period.
}
\examples{
data(data_all)
sdii(data = data_all$rr)
}
\references{
Michele Brunetti, Maurizio Maugerib, Teresa Nanni, (2001) Changes in total precipitation, rainy days and extreme events in northeastern Italy, International Journal of Climatology
}
