% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clus_lme.R
\name{clus_lme}
\alias{clus_lme}
\title{Linear Mixed-Effects Models for a continuous diagnostic test or a biomarker (or a classifier).}
\usage{
clus_lme(
  fixed_formula,
  name_class,
  name_clust,
  data = sys.frame(sys.parent()),
  subset,
  na_action = na.fail,
  levl_class = NULL,
  ap_var = TRUE,
  boxcox = FALSE,
  interval_lambda = c(-2, 2),
  trace = TRUE,
  ...
)
}
\arguments{
\item{fixed_formula}{a two-sided linear formula object, describing the fixed-effects part of the model for three classes, with the response on the left of ~ operator and the terms, separated by + operators, on the right. For example, \code{Y ~ X1 + X2}, \code{Y ~ X1 + X2 + X1:X2} or \code{log(Y) ~ X1 + X2 + I(X1^2)}.}

\item{name_class}{name of variable indicating three classes (or three groups) in the data.}

\item{name_clust}{name of variable indicating clusters in the data.}

\item{data}{a data frame containing the variables in the model.}

\item{subset}{an optional expression indicating the subset of the rows of data that should be used in the fit. This can be a logical vector, or a numeric vector indicating which observation numbers are to be included, or a character vector of the row names to be included. All observations are included by default.}

\item{na_action}{a function that indicates what should happen when the data contain NAs. The default action (\code{\link[stats]{na.fail}}) causes \code{clus_lme} to print an error message and terminate if there are any incomplete observations.}

\item{levl_class}{a vector (of strings) containing the ordered name chosen for the disease classes. The ordering is intended to be ``increasing'' with respect to the disease severity. If \code{levl_class = NULL} (default), the elements of the vector will be automatically determined from data, by considering the order of the means of the test values for each disease class (diagnostic group).}

\item{ap_var}{a logical value. Default = \code{TRUE}. If set to \code{TRUE}, the estimated covariance matrix for all estimated parameters in the model will be obtained (by using the sandwich formula).}

\item{boxcox}{a logical value. Default = \code{FALSE}. If set to \code{TRUE}, a Box-Cox transformation will be applied to the model.}

\item{interval_lambda}{a vector containing the end-points of the interval for searching the Box-Cox parameter, \code{lambda}. Default = (-2, 2).}

\item{trace}{a logical value. Default = \code{TRUE}. If set to \code{TRUE}, the information about the check for the monotonic ordering of test values will be provided.}

\item{...}{additional arguments for \code{\link[nlme]{lme}}, such as \code{control}, \code{contrasts}.}
}
\value{
\code{clus_lme} returns an object of class "clus_lme" class, i.e., a list containing at least the following components:

\item{call}{the matched call.}
\item{est_para}{a vector containing the estimated parameters.}
\item{se_para}{a vector containing the standard errors.}
\item{vcov_sand}{the estimated covariance matrix for all estimated parameters.}
\item{residual}{a list of residuals.}
\item{fitted}{a list of fitted values.}
\item{randf}{a vector of estimated random effects for each cluster level.}
\item{n_coef}{total number of coefficients included in the model.}
\item{n_p}{total numbers of regressors in the model.}
\item{icc}{an estimate of intra-class correlation - ICC}
\item{terms}{the \code{\link[stats]{terms}} object used.}
\item{boxcox}{logical value indicating whether the Box-Cox transformation was applied or not.}
\item{data}{data frame is used to fitting model.}

Generic functions such as \code{print} and \code{plot} are also used to show results of the fit.
}
\description{
\code{clus_lme} fits the cluster-effect model for a continuous diagnostic test in a three-class setting as described in Xiong et al. (2018) and To et al. (2022).
}
\details{
This function fits a linear mixed-effect model for a continuous diagnostic test in a three-class setting in order to account for the cluster and covariates effects on the test result. See Xiong et al. (2018) and To et al. (2022) for more details.
\itemize{
\item Estimation is done by using \code{\link[nlme]{lme}} with the restricted maximum log-likelihood (REML) method.
\item Box-Cox transformation for the model can be used when the distributions of test results are skewed (Gurka et al. 2006). The estimation procedure is described in To et al. (2022). The Box-Cox parameter \eqn{\lambda} is estimated by a grid search on the interval (-2, 2), as discussed in Gurka and Edwards (2011).
\item The estimated variance-covariance matrix for the estimated parameters are obtained by sandwich formula (see, Liang and Zeger, 1986; Kauermann and Carroll, 2001; Mancl and DeRouen, 2001) as discussed in To et al. (2022).
}
}
\examples{
## Example 1:
data(data_3class)
head(data_3class)
## A model with two covariate
out1 <- clus_lme(fixed_formula = Y ~ X1 + X2, name_class = "D",
                 name_clust = "id_Clus", data = data_3class)
print(out1)
plot(out1)

\donttest{
## Example 2: Box-Cox transformation
data(data_3class_bcx)
out2 <- clus_lme(fixed_formula = Y ~ X, name_class = "D",
                 name_clust = "id_Clus", data = data_3class_bcx,
                 boxcox = TRUE)
print(out2)
plot(out2)
}

}
\references{
Gurka, M. J., Edwards, L. J. , Muller, K. E., and Kupper, L. L. (2006) ``Extending the Box-Cox transformation to the linear mixed model''. \emph{Journal of the Royal Statistical Society: Series A (Statistics in Society)}, \bold{169}, 2, 273-288.

Gurka, M. J. and Edwards, L. J. (2011) ``Estimating variance components and random effects using the box-cox transformation in the linear mixed model''. \emph{Communications in Statistics - Theory and Methods}, \bold{40}, 3, 515-531.

Kauermann, G. and Carroll, R. J. (2001)
``A note on the efficiency of sandwich covariance matrix estimation''.
\emph{Journal of the American Statistical Association}, \bold{96}, 456, 1387-1396.

Liang, K. Y. and Zeger, S. L. (1986)
``Longitudinal data analysis using generalized linear models''. \emph{Biometrika}, \bold{73}, 1, 13-22.

Mancl, L. A. and DeRouen, T. A. (2001) ``A covariance estimator for GEE with improved small-sample properties''.
 \emph{Biometrics}, \bold{57}, 1, 126-134.

To, D-K., Adimari, G., Chiogna, M. and Risso, D. (2022)
``Receiver operating characteristic estimation and threshold selection criteria in three-class classification problems for clustered data''. \emph{Statistical Methods in Medical Research}, \bold{7}, 31, 1325-1341.

Xiong, C., Luo, J., Chen L., Gao, F., Liu, J., Wang, G., Bateman, R. and Morris, J. C. (2018)
``Estimating diagnostic accuracy for clustered ordinal diagnostic groups in the three-class case -- Application to the early diagnosis of Alzheimer disease''.
\emph{Statistical Methods in Medical Research}, \bold{27}, 3, 701-714.
}
