% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{choose_stable_clusters}
\alias{choose_stable_clusters}
\title{Choose stable clusters based on ECC and frequency}
\usage{
choose_stable_clusters(
  clusters_list,
  ecc_threshold = 0.9,
  freq_threshold = 30,
  summary_function = mean
)
}
\arguments{
\item{clusters_list}{List of clusters obtained from the
\code{get_clusters_from_clustassess_object} function.}

\item{ecc_threshold}{Minimum ECC value to consider a cluster as stable.
Default is 0.9.}

\item{freq_threshold}{Minimum total frequency of the partitions to consider.
Default is 30.}

\item{summary_function}{Function to summarize the ECC values. Default
is \code{mean}. To match the results from the ClustAssess Shiny App, use
\code{median}.}
}
\value{
A list of stable clusters that satisfy the ECC and frequency.
}
\description{
Filter the list of clusters obtained by the automatic
ClustAssess pipeline using the ECC and frequency thresholds. The ECC
threshold is meant to filter out the partitions that are highly sensitive
to the change of the random seed, while the purpose of the frequency
threshold is to assure a statistical significance of the inferred stability.
}
