% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hclustvar.R
\name{plot.hclustvar}
\alias{plot.hclustvar}
\title{Dendrogram of the hierarchy of variables}
\usage{
\method{plot}{hclustvar}(x, type = "tree", sub = "", ...)
}
\arguments{
\item{x}{an object of class \code{hclustvar}.}

\item{type}{if type="tree" plot of the dendrogram and if type="index"
aggregation levels plot.}

\item{sub}{a sub title for the plot.}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
Dendrogram of the hierarchy of variables resulting from \code{hclustvar}
and aggregation levels plot.
}
\examples{
data(wine)
X.quanti <- PCAmixdata::splitmix(wine)$X.quanti
X.quali <- PCAmixdata::splitmix(wine)$X.quali
tree <- hclustvar(X.quanti,X.quali)
plot(tree)

#Aggregation levels plot
plot(tree,type="index")

}
\seealso{
\code{\link{hclustvar}}
}
